import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/form_section/receive_currency_dropdown.dart';

import '../../../../../../core/utils/my_color.dart';
import '../../../../../../data/controller/home/home_controller.dart';
import '../../../../../components/text-form-field/custom_amount_text_field.dart';

// ignore: must_be_immutable
class ReceiveCurrencyField extends StatelessWidget {
  final bool enableOptionalItem;

  const ReceiveCurrencyField({super.key, this.enableOptionalItem = false});

  @override
  Widget build(BuildContext context) {
    double width = MediaQuery.of(context).size.width;
   print("this is status ${enableOptionalItem}");
    return GetBuilder<HomeController>(builder: (controller) {
      return Container(
        width: width,
        decoration: BoxDecoration(
          border: Border.all(color: MyColor.customBorderColor, width: .5),
          borderRadius: BorderRadius.circular(4),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Expanded(
                child: ReceiveCurrencyDropDown(
              isBorder: false,
              enableOptionalItem: enableOptionalItem,
            )),
            SizedBox(
              child: Container(
                color: const Color(0xFFD0D0D0),
                height: 20,
                width: 0.5,
              ),
            ),
            Expanded(
              child: CustomAmountTextField(
                labelText: '',
                hintText: controller.receiveAmount.toString(),
                currency: controller.selectedReceiveCountry.currency ?? controller.homeRepo.apiClient.getCurrencyOrUsername(isCurrency: true),
                onChanged: (value) {
                  controller.receiveCurrencyExchangeRateCalculate(value);
                },
                needLabelText: false,
                readOnly: controller.selectedReceiveCountry.id == -1 ? true : false,
                controller: controller.receivingAmountController,
              ),
            )
          ],
        ),
      );
    });
  }
}
